<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoices extends Eloquent {

	protected $table = 'invoices';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('uuid', 'entity_id', 'terms', 'period', 'total_amount', 'transaction_id', 'payment_mode_id');

	public function paymentMode()
	{
		return $this->hasOne('PaymentMode', 'payment_mode_id');
	}

	public function entity()
	{
		return $this->hasOne('Entities', 'entity_id');
	}

}