<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Ads extends Model 
{

    protected $table = 'ads';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('image', 'start_date_time', 'end_date_time');

    public function entity()
    {
        return $this->hasOne('Entities', 'entity_id');
    }

}