<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EntityRatings extends Model 
{

    protected $table = 'entity_ratings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'entity_id', 'rating', 'comment');

    public function user()
    {
        return $this->hasOne('ConsumerUsers', 'user_id');
    }

    public function entity()
    {
        return $this->hasOne('Entities', 'entity_id');
    }

}