<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConsumerUsersTable extends Migration {

	public function up()
	{
		Schema::create('consumer_users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('uuid', 90);
			$table->string('username', 255);
			$table->string('email', 255);
			$table->string('first_name', 255)->nullable();
			$table->string('last_name', 255)->nullable();
			$table->enum('user_type', array(''));
			$table->tinyInteger('email_verified')->nullable()->default('0');
			$table->tinyInteger('password_changed')->nullable()->default('0');
			$table->string('email_verified_token', 255)->nullable();
			$table->string('password_changed_token', 255)->nullable();
			$table->string('password', 255);
		});
	}

	public function down()
	{
		Schema::drop('consumer_users');
	}
}