<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEntityBranchesTable extends Migration {

	public function up()
	{
		Schema::create('entity_branches', function(Blueprint $table) {
			$table->increments('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid', 90);
			$table->string('slug', 255);
			$table->string('phone', 55)->nullable();
			$table->string('contact_name', 255)->nullable();
			$table->string('contact_phone', 50)->nullable();
			$table->string('contact_email', 255)->nullable();
			$table->string('country', 155)->nullable();
			$table->string('street_no', 255)->nullable();
			$table->string('city', 255)->nullable();
			$table->string('zip_code', 20)->nullable();
			$table->string('state', 255)->nullable();
			$table->string('cuisine', 255)->nullable();
			$table->integer('service_id')->unsigned();
			$table->tinyInteger('publish_merchant')->nullable()->default('0');
			$table->integer('status_id')->unsigned();
			$table->integer('entity_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('entity_branches');
	}
}