<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->softDeletes();
			$table->uuid('uuid', 90);
			$table->integer('order_id')->unsigned();
			$table->string('transaction_id', 90);
			$table->integer('payment_mode_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}