<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('person_id')->unsigned();
			$table->integer('company_id')->unsigned();
			$table->integer('company_address_id')->unsigned();
			$table->integer('current_infrastructure_id')->unsigned();
			$table->integer('api_id')->unsigned();
			$table->string('picture', 255)->nullable();
			$table->string('email', 255)->index();
			$table->string('password', 255);
			$table->string('mobile_phone', 100)->nullable();
			$table->string('skype', 100)->nullable();
			$table->string('remember_token', 255)->nullable();
			$table->string('activation_key', 255)->nullable();
			$table->datetime('lock_time')->nullable();
			$table->datetime('last_login_attempts')->nullable();
			$table->integer('nb_login_attempts');
			$table->tinyInteger('status')->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}