<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCountriesTable extends Migration {

	public function up()
	{
		Schema::create('countries', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100)->index();
			$table->string('code', 4)->nullable();
			$table->text('address_format')->nullable();
			$table->enum('distance_unit', array('km', 'miles'));
			$table->float('longitude');
			$table->float('latitude');
			$table->integer('currency_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('countries');
	}
}