<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CompanyOption extends Eloquent {

	protected $table = 'companies_options';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function company()
	{
		return $this->belongsTo('Company');
	}

	public function application()
	{
		return $this->belongsTo('Application');
	}

}