<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeachersTable extends Migration {

	public function up()
	{
		Schema::create('teachers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('last_name');
			$table->string('first_name');
			$table->string('extension_name');
			$table->string('middle_name');
			$table->string('sex');
			$table->string('id_number')->unique();
			$table->string('code')->unique();
			$table->date('date_of_birth');
			$table->string('contact');
			$table->string('email')->unique();
		});
	}

	public function down()
	{
		Schema::drop('teachers');
	}
}