<?php

namespace App\Models\GestionPartenaire;

class Partenaire extends Eloquent {

	protected $table = 'partenaires';
	public $timestamps = true;
	protected $fillable = array('raison_social', 'secteur_activite', 'adresse', 'contact', 'personne_morale', 'statut');

	public function sites()
	{
		return $this->hasMany('App\Models\GestionSiteBusiness\Site', 'partenaire_id');
	}

	public function contrat()
	{
		return $this->hasOne('App\Models\GestionContrat\Contrat', 'partenaire_id');
	}

	public function users()
	{
		return $this->hasMany('App\Models\User', 'parteniare_id');
	}

	public function comptes()
	{
		return $this->hasMany('App\Models\GestionTransaction\Compte', 'pasrtenaire_id');
	}

}