<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('isbn', 8);
			$table->string('name', 250);
			$table->integer('category');
			$table->boolean('published');
			$table->decimal('pricing');
			$table->text('short_description');
			$table->text('long_description');
			$table->float('rating_cache');
			$table->integer('rating_count');
			$table->string('icon', 250);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}