<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjetsTable extends Migration {

	public function up()
	{
		Schema::create('projets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('designation', 100);
			$table->text('description');
			$table->integer('duree')->unsigned()->default('0');
			$table->decimal('cou_estime')->default('0');
			$table->integer('porteur_id')->unsigned();
			$table->integer('evolution')->unsigned()->default('0');
			$table->enum('etat', array('enattente', 'encours', 'suspendu', 'termine'));
			$table->integer('Category_Projet_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('projets');
	}
}