<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('recipes', function(Blueprint $table) {
			$table->foreign('cate_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('directions', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ingred_nutrionvals', function(Blueprint $table) {
			$table->foreign('ingred_id')->references('id')->on('ingredients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ingred_nutrionvals', function(Blueprint $table) {
			$table->foreign('nutrition_id')->references('id')->on('nutritionvals')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recipe_ingredients', function(Blueprint $table) {
			$table->foreign('recipe_id')->references('id')->on('recipes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recipe_ingredients', function(Blueprint $table) {
			$table->foreign('ingred_id')->references('id')->on('ingredients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_details', function(Blueprint $table) {
			$table->dropForeign('user_details_user_id_foreign');
		});
		Schema::table('recipes', function(Blueprint $table) {
			$table->dropForeign('recipes_cate_id_foreign');
		});
		Schema::table('directions', function(Blueprint $table) {
			$table->dropForeign('directions_recipe_id_foreign');
		});
		Schema::table('ingred_nutrionvals', function(Blueprint $table) {
			$table->dropForeign('ingred_nutrionvals_ingred_id_foreign');
		});
		Schema::table('ingred_nutrionvals', function(Blueprint $table) {
			$table->dropForeign('ingred_nutrionvals_nutrition_id_foreign');
		});
		Schema::table('recipe_ingredients', function(Blueprint $table) {
			$table->dropForeign('recipe_ingredients_recipe_id_foreign');
		});
		Schema::table('recipe_ingredients', function(Blueprint $table) {
			$table->dropForeign('recipe_ingredients_ingred_id_foreign');
		});
	}
}