<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfferKeyInfosTable extends Migration {

	public function up()
	{
		Schema::create('offer_key_infos', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->integer('connected_item')->unsigned()->nullable()->default('0');
			$table->integer('customary_offer_id')->unsigned()->nullable();
			$table->integer('order')->unsigned()->nullable();
			$table->string('state')->nullable()->index();
			$table->boolean('active')->default(1);
			$table->tinyInteger('primary_field')->nullable()->default('0');
			$table->text('description')->nullable();
			$table->string('typical_label')->nullable();
			$table->string('typical_value')->nullable();
			$table->integer('offer_category_id')->unsigned();
			$table->boolean('is_mandatory')->default(1);
			$table->boolean('is_user_change')->default(0);
			$table->string('user_change_text')->nullable();
			$table->boolean('date_days_applicable')->default(0);
			$table->string('date_days_text')->nullable();
			$table->boolean('auto_populate_date')->default(0);
			$table->boolean('amount_comment_applicable')->default(0);
			$table->string('amount_comment_text')->nullable();
			$table->string('placeholder_text')->nullable();
			$table->string('default_value')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('offer_key_infos');
	}
}