<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Studentwork extends Model 
{

    protected $table = 'studentworks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('homework_id', 'user_id', 'time_spent', 'work_date', 'right_percentage', 'counter', 'percentage_counter', 'status');

    public function homeWork()
    {
        return $this->belongsTo('Homework');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}