<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Media extends Model 
{

    protected $table = 'media';
    public $timestamps = true;

    public function tags()
    {
        return $this->belongsToMany('MediaTag');
    }

    public function project()
    {
        return $this->belongsTo('Project');
    }

    public function categories()
    {
        return $this->hasMany('MediaCategory');
    }

    public function products()
    {
        return $this->hasMany('MediaProduct');
    }

    public function users()
    {
        return $this->hasMany('MediaUser');
    }

}