<?php

namespace App;

class Projet extends Eloquent {

	protected $table = 'projet';
	public $timestamps = true;
	protected $fillable = array('nom', 'type', 'etat_projet', 'date_debut', 'date_fin', 'date_cloture', 'budget', 'id_maitre_doeuvre', 'id_user', 'id_maitre_douvrage', 'id_mission_decontrole', 'delai_execution', 'budget_prestataire', 'budget_maitre_d_oeuvre');

	public function mission_de_controle()
	{
		return $this->belongsTo('App\Mission_de_controle');
	}

	public function ordre_de_service()
	{
		return $this->hasMany('App\Ordre_de_service');
	}

	public function lot()
	{
		return $this->hasMany('App\Lot');
	}

	public function etat_davancement()
	{
		return $this->hasMany('App\Etat_davancement');
	}

	public function maitre_d_ouvrage()
	{
		return $this->belongsTo('App\Maitre_d_ouvrage');
	}

	public function maitre_doeuvre()
	{
		return $this->belongsTo('App\Maitre_doeuvre');
	}

	public function probleme()
	{
		return $this->hasMany('App\Probleme');
	}

	public function prestataire()
	{
		return $this->belongsToMany('App\Prestataire');
	}

	public function utilisateur()
	{
		return $this->belongsTo('App\Utilisateur');
	}

	public function recommandation()
	{
		return $this->hasMany('App\Recommandation');
	}

}