<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVinsTable extends Migration {

	public function up()
	{
		Schema::create('vins', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('nom', 255)->unique();
			$table->string('taille', 255)->nullable();
			$table->string('couleur', 255)->nullable();
			$table->string('description', 255)->nullable();
			$table->integer('id_marque')->unsigned();
			$table->integer('id_type_vin')->unsigned();
			$table->float('degre')->nullable();
			$table->float('age')->nullable();
			$table->string('image', 255)->nullable();
			$table->tinyInteger('statut');
		});
	}

	public function down()
	{
		Schema::drop('vins');
	}
}