<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('entrees_stock', function(Blueprint $table) {
			$table->foreign('id_prix')->references('id')->on('vins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entrees_stock', function(Blueprint $table) {
			$table->foreign('id_fournisseur')->references('id')->on('fournisseur')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('entrees_stock', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ventes', function(Blueprint $table) {
			$table->foreign('id_client')->references('id')->on('clients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lignes_vente', function(Blueprint $table) {
			$table->foreign('id_vente')->references('id')->on('ventes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lignes_vente', function(Blueprint $table) {
			$table->foreign('id_prix')->references('id')->on('prix')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->foreign('id_vin')->references('id')->on('vins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->foreign('id_entree_stock')->references('id')->on('entrees_stock')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prix', function(Blueprint $table) {
			$table->foreign('id_vin')->references('id')->on('vins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('id_user')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('entrees_stock', function(Blueprint $table) {
			$table->dropForeign('entrees_stock_id_prix_foreign');
		});
		Schema::table('entrees_stock', function(Blueprint $table) {
			$table->dropForeign('entrees_stock_id_fournisseur_foreign');
		});
		Schema::table('entrees_stock', function(Blueprint $table) {
			$table->dropForeign('entrees_stock_id_user_foreign');
		});
		Schema::table('ventes', function(Blueprint $table) {
			$table->dropForeign('ventes_id_client_foreign');
		});
		Schema::table('lignes_vente', function(Blueprint $table) {
			$table->dropForeign('lignes_vente_id_vente_foreign');
		});
		Schema::table('lignes_vente', function(Blueprint $table) {
			$table->dropForeign('lignes_vente_id_prix_foreign');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->dropForeign('unites_id_vin_foreign');
		});
		Schema::table('unites', function(Blueprint $table) {
			$table->dropForeign('unites_id_entree_stock_foreign');
		});
		Schema::table('prix', function(Blueprint $table) {
			$table->dropForeign('prix_id_vin_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_id_user_foreign');
		});
	}
}