<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDomainsTable extends Migration {

	public function up()
	{
		Schema::create('domains', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('parent_id')->index();
			$table->string('name');
			$table->enum('type', array('partner', 'klant', 'verzekeraar', 'provider'));
			$table->string('code');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('domains');
	}
}