<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductosTable extends Migration {

	public function up()
	{
		Schema::create('productos', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('id_categorias')->unsigned();
			$table->integer('id_marca')->unsigned();
			$table->text('title')->nullable();
			$table->text('description')->nullable();
			$table->text('title_tc')->nullable();
			$table->text('title_og')->nullable();
			$table->text('description_tc')->nullable();
			$table->text('description_og')->nullable();
			$table->string('robots', 100)->default('index,follow');
			$table->text('h1')->nullable();
			$table->text('canonical')->nullable();
			$table->text('nombre')->nullable();
			$table->mediumText('descripcion_corta')->nullable();
			$table->longText('descripcion_larga')->nullable();
			$table->string('foto_principal', 255)->nullable();
			$table->text('slug')->unique();
			$table->decimal('alto', 5,2);
			$table->decimal('ancho', 5,2);
			$table->decimal('fondo', 5,2);
			$table->integer('orden');
			$table->integer('id_ofertas')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('productos');
	}
}