<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->timestamps();
			$table->softDeletes();
			$table->string('email')->nullable();
			$table->string('password')->nullable();
			$table->tinyInteger('gender')->nullable();
			$table->string('access_pin')->nullable();
			$table->string('image')->nullable();
			$table->tinyInteger('confirmed')->nullable();
			$table->string('confirmation_code')->nullable();
			$table->integer('contact_id')->unsigned();
			$table->tinyInteger('status')->nullable();
			$table->integer('store_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}