<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->foreign('quest_id')->references('id')->on('quests')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_quests', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('user_quests', function(Blueprint $table) {
			$table->foreign('quest_id')->references('id')->on('quests')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_user_id_foreign');
		});
		Schema::table('user_roles', function(Blueprint $table) {
			$table->dropForeign('user_roles_role_id_foreign');
		});
		Schema::table('results', function(Blueprint $table) {
			$table->dropForeign('results_quest_id_foreign');
		});
		Schema::table('user_quests', function(Blueprint $table) {
			$table->dropForeign('user_quests_user_id_foreign');
		});
		Schema::table('user_quests', function(Blueprint $table) {
			$table->dropForeign('user_quests_quest_id_foreign');
		});
	}
}