<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCuponesTable extends Migration {

	public function up()
	{
		Schema::create('cupones', function(Blueprint $table) {
			$table->increments('id');
			$table->string('codigo', 50);
			$table->char('aplicar', 1);
			$table->date('desde');
			$table->date('hasta');
			$table->decimal('descuento', 8,2);
			$table->enum('tipo', array(''E'', ''P''));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cupones');
	}
}