<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductosTable extends Migration {

	public function up()
	{
		Schema::create('productos', function(Blueprint $table) {
			$table->increments('id');
			$table->text('slug');
			$table->string('codigo_montura', 20);
			$table->string('codigo_interno', 20);
			$table->string('ean', 13);
			$table->integer('color_montura_id');
			$table->integer('color_lente_id');
			$table->integer('material_id');
			$table->integer('forma_id');
			$table->string('imagen', 255);
			$table->integer('ojo');
			$table->integer('puente');
			$table->integer('varilla');
			$table->decimal('pvo', 10,2);
			$table->decimal('pvp', 10,2);
			$table->smallInteger('stock');
			$table->integer('common_fields_id');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('productos');
	}
}