<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->text('question_text');
			$table->enum('question_type', array('text', 'textarea', 'check', 'radio', 'file', 'select'));
			$table->integer('max_file_size')->nullable();
			$table->integer('max_files_count')->nullable();
			$table->string('file_types');
			$table->boolean('required');
			$table->bigInteger('parent_question')->unsigned()->nullable();
			$table->string('show_if_answer_in');
			$table->integer('order');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}