<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('recipes', function(Blueprint $table) {
			$table->foreign('entrant_id')->references('id')->on('entrants')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('recipes', function(Blueprint $table) {
			$table->dropForeign('recipes_entrant_id_foreign');
		});
	}
}