<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specializations', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('specializations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specialization_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('specialization_user', function(Blueprint $table) {
			$table->foreign('specialization_id')->references('id')->on('specializations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('method_user', function(Blueprint $table) {
			$table->foreign('method_id')->references('id')->on('methods')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('method_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('wish_lists', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('wish_lists', function(Blueprint $table) {
			$table->foreign('favourite_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('area_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('area_user', function(Blueprint $table) {
			$table->foreign('area_id')->references('id')->on('areas')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('attachmentables', function(Blueprint $table) {
			$table->foreign('attachment_id')->references('id')->on('attachments')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('areas', function(Blueprint $table) {
			$table->dropForeign('areas_city_id_foreign');
		});
		Schema::table('specializations', function(Blueprint $table) {
			$table->dropForeign('specializations_parent_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('specialization_user', function(Blueprint $table) {
			$table->dropForeign('specialization_user_user_id_foreign');
		});
		Schema::table('specialization_user', function(Blueprint $table) {
			$table->dropForeign('specialization_user_specialization_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('method_user', function(Blueprint $table) {
			$table->dropForeign('method_user_method_id_foreign');
		});
		Schema::table('method_user', function(Blueprint $table) {
			$table->dropForeign('method_user_user_id_foreign');
		});
		Schema::table('wish_lists', function(Blueprint $table) {
			$table->dropForeign('wish_lists_user_id_foreign');
		});
		Schema::table('wish_lists', function(Blueprint $table) {
			$table->dropForeign('wish_lists_favourite_id_foreign');
		});
		Schema::table('area_user', function(Blueprint $table) {
			$table->dropForeign('area_user_user_id_foreign');
		});
		Schema::table('area_user', function(Blueprint $table) {
			$table->dropForeign('area_user_area_id_foreign');
		});
		Schema::table('attachmentables', function(Blueprint $table) {
			$table->dropForeign('attachmentables_attachment_id_foreign');
		});
	}
}