<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdsTable extends Migration {

	public function up()
	{
		Schema::create('ads', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name');
			$table->longText('body');
			$table->enum('status', array('live', 'sold', 'canceled'));
			$table->decimal('price', 10,2)->default('0');
			$table->bigInteger('city_id')->unsigned();
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('category_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ads');
	}
}