<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationsTable extends Migration {

	public function up()
	{
		Schema::create('Reservations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned();
			$table->integer('site_id')->unsigned();
			$table->integer('period_id')->unsigned();
			$table->integer('number_visitors')->unsigned()->default('1');
			$table->text('note');
			$table->date('date');
			$table->decimal('montant');
			$table->boolean('payment_status');
		});
	}

	public function down()
	{
		Schema::drop('Reservations');
	}
}