<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEventsTable extends Migration {

	public function up()
	{
		Schema::create('events', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 255);
			$table->datetime('startdate');
			$table->datetime('enddate');
			$table->string('url_event', 155)->nullable()->default('www.example.com');
			$table->boolean('allDay_event')->default(0);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('events');
	}
}