<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('entries', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('entry_id')->references('id')->on('entries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relationships', function(Blueprint $table) {
			$table->foreign('following_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relationships', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('entries', function(Blueprint $table) {
			$table->dropForeign('entries_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_entry_id_foreign');
		});
		Schema::table('relationships', function(Blueprint $table) {
			$table->dropForeign('relationships_following_id_foreign');
		});
		Schema::table('relationships', function(Blueprint $table) {
			$table->dropForeign('relationships_follower_id_foreign');
		});
	}
}