<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppCardEffectTable extends Migration {

	public function up()
	{
		Schema::create('app_card_effect', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->string('description');
			$table->enum('player_affected', array('self', 'opponent'));
			$table->enum('type', array('damage', 'heal'));
			$table->integer('quantity');
		});
	}

	public function down()
	{
		Schema::drop('app_card_effect');
	}
}