<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAppCardTable extends Migration {

	public function up()
	{
		Schema::create('app_card', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 50);
			$table->enum('type', array('Monstre', 'Sort'));
			$table->integer('cost')->default('1');
			$table->integer('health')->nullable();
			$table->integer('strength')->nullable();
			$table->string('picture', 100);
			$table->integer('effect_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('app_card');
	}
}