<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLearnersTable extends Migration {

	public function up()
	{
		Schema::create('learners', function(Blueprint $table) {
			$table->increments('id');
			$table->string('firstname');
			$table->string('lastname');
			$table->string('email')->unique();
			$table->string('phone')->unique();
			$table->string('password');
			$table->timestamp('email_verified_at')->nullable();
			$table->string('remember_token', 100)->nullable();
			$table->timestamps();
			$table->increments('city');
			$table->increments('country');
			$table->date('dob');
			$table->increments('grade_id');
		});
	}

	public function down()
	{
		Schema::drop('learners');
	}
}